USE [NWIC_PanelMgmt]
GO

--Drop this foreign key constraint, necessary before dropping the table.
ALTER TABLE  [App].[NVCC_StationAdmins] drop constraint [FK_NVCC_Stations_Sta3n]

IF (SELECT OBJECT_ID('App.NVCC_Stations')) IS NOT NULL
DROP TABLE [App].[NVCC_Stations]

CREATE TABLE [App].[NVCC_Stations](
	[Sta3n]               [smallint]     NOT NULL,
	[MedCtr]              [varchar](60)  NOT NULL,
	[FullAddress]         [varchar](130) NULL,
	[StreetAddress1]      [varchar](130) NULL,
	[StreetAddress2]      [varchar](130) NULL,
    [City]                [varchar](50)  NULL,
	[State]               [varchar](30)  NULL,
	[Zip]                 [varchar](50)  NULL,
    [FacilityPhoneNumber] [varchar](20)  NULL,
    [FacilityFaxNumber]   [varchar](20)  NULL,
	[TPAOK]               [varchar](3)   NOT NULL,
	[TPAName]             [varchar](30)  NULL,
	[TPAPhone]            [varchar](20)  NULL,
	[TPAFax]              [varchar](20)  NULL
CONSTRAINT [PK_NVCC_Stations_Sta3n] PRIMARY KEY CLUSTERED ([Sta3n] ASC) 
) ON [DefFG] WITH (DATA_COMPRESSION = PAGE)
GO


INSERT INTO [App].[NVCC_Stations]
           ([Sta3n]
           ,[MedCtr]
           ,[FullAddress]
           ,[StreetAddress1]
           ,[StreetAddress2]
           ,[City]
           ,[State]
           ,[Zip]
           ,[FacilityPhoneNumber]
           ,[FacilityFaxNumber]
           ,[TPAOK]
           ,[TPAName]
           ,[TPAPhone]
           ,[TPAFax])

SELECT Division.Sta3n,
       MedCtr = CASE
          When Division.DivisionName like '% VAMC%' OR
               Division.DivisionName like '% HCS'   OR
               Division.DivisionName like '% Medical Center'
          Then Division.DivisionName
          When Institution.InstitutionName like '% VAMC%' OR
               Institution.InstitutionName like '% HCS'   OR
               Institution.InstitutionName like '% Medical Center'
          Then Institution.InstitutionName
          Else Institution.InstitutionName
          End,
       [App].[udf_TitleCase](Institution.StreetAddress1 + ', ' +
                             Institution.City + ', ' + 
                             [State].[State] + ' ' + 
                             Institution.Zip) AS [FullAddress],
       Institution.StreetAddress1,
       Institution.StreetAddress2,
       Institution.City,
       [State].[State],
       Institution.Zip,
       'Enter Me!' AS [FacilityPhoneNumber],
       'Enter Me!' AS [FacilityFaxNumber],
       'Yes' AS TPAOK,
       'Enter Me!' AS TPAName,
       'Enter Me!' AS TPAPhone,
       'Enter Me!' AS TPAFax
--into #jktest
  FROM (CDWWork.Dim.Division Division
        INNER JOIN CDWWork.Dim.Institution Institution --SPVNext.Dim.Institution Institution
           ON (Division.InstitutionSID = Institution.InstitutionSID))
        INNER JOIN CDWWork.Dim.State State
          ON (State.StateSID = Institution.StateSID)
 WHERE Division.DivisionName NOT LIKE '%*Missing*%'
   AND Division.DivisionName NOT LIKE 'ZZ%'
   AND len(division.sta6a) = 3     -- Only want stations, not CBOCS, Doms, etc.
   AND Division.Sta3n NOT IN (648, 531)  -- These were already in the table.
   AND Institution.InstitutionName NOT LIKE '%*Missing*%'
   AND CONVERT(VARCHAR, Institution.Sta3n) = Institution.InstitutionCode  -- See "Wrong Anchorage"


SELECT *
  FROM [NWIC_PanelMgmt].[App].[NVCC_Stations]

--Re-create the foreign key constraint from NVCC_StationAdmins
ALTER TABLE [App].[NVCC_StationAdmins]  WITH CHECK ADD  CONSTRAINT [FK_NVCC_Stations_Sta3n] FOREIGN KEY([Sta3n])
REFERENCES [App].[NVCC_Stations] ([Sta3n])
GO

ALTER TABLE [App].[NVCC_StationAdmins] CHECK CONSTRAINT [FK_NVCC_Stations_Sta3n]
GO

